#include <ESP8266WiFi.h>
#include <ThingSpeak.h>
#include <time.h>  // For date and time functions

const char* ssid = "Your SSID";         // Your Wi-Fi SSID
const char* password = "Your Password"; // Your Wi-Fi password
unsigned long myChannelNumber = ????????;  // Replace with your ThingSpeak channel number
const char* myWriteAPIKey = "?????????";           // Replace with your ThingSpeak Write API Key

WiFiClient client;

unsigned long previousMillis = 0;   // Stores the last time wind speed was measured
const long interval = 10000;        // Interval at which to upload data (milliseconds)
const int anemometerPin = D2;       // Pin connected to anemometer
volatile int windSpeedCount = 0;    // Counts the number of revolutions
float windSpeed = 0.0;              // Wind speed in m/s

void IRAM_ATTR countRevolutions() {
  windSpeedCount++;
}

void setup() {
  Serial.begin(115200);
  pinMode(anemometerPin, INPUT);
  attachInterrupt(digitalPinToInterrupt(anemometerPin), countRevolutions, FALLING);

  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("Connected to Wi-Fi");

  ThingSpeak.begin(client);  // Initialize ThingSpeak

  // Initialize NTP
  configTime(0, 0, "pool.ntp.org", "time.nist.gov");
  setenv("TZ", "GMT0BST,M3.5.0/1,M10.5.0", 1); // Set timezone (example: GMT for UK)
  tzset();
}

void loop() {
  unsigned long currentMillis = millis();

  if (currentMillis - previousMillis >= interval) {
    previousMillis = currentMillis;

    // Calculate wind speed
    float circumference = 2.0 * 3.14159 * 0.65;  // Circumference in meters (radius = 0.65m)
    windSpeed = (windSpeedCount / 2.0) * (circumference / interval) * 1000.0;  // m/s

    // Get current time
    time_t now;
    struct tm timeinfo;
    time(&now);
    localtime_r(&now, &timeinfo);

    // Format date and time
    char timeString[50];
    strftime(timeString, sizeof(timeString), "%Y-%m-%d %H:%M:%S", &timeinfo);

    // Print date, time, and wind speed
    Serial.print("Date & Time: ");
    Serial.print(timeString);
    Serial.print(" - Wind Speed: ");
    Serial.print(windSpeed);
    Serial.println(" m/s");

    // Reset the counter
    windSpeedCount = 0;

    // Send data to ThingSpeak
    ThingSpeak.setField(1, windSpeed);
    int x = ThingSpeak.writeFields(myChannelNumber, myWriteAPIKey);
    if(x == 200) {
        Serial.println("Channel update successful.");
    } else {
        Serial.println("Problem updating channel. HTTP error code " + String(x));
    }

    delay(20000); // Wait for 20 seconds before next update (adjust as needed)
  }
}
